# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: D

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate to signal willingness for mutual cooperation
    if not my_history:
        return "C"
    
    # Check if opponent's code is always defect
    always_defect = False
    if 'return "D"' in opponent_program_code and 'if' not in opponent_program_code:
        always_defect = True
    if always_defect:
        return "D"
    
    # Check if opponent's code is identical to mine (self-play)
    if opponent_program_code.strip() == friendly_neighbor.__code__.co_code:
        return "C"
    
    # Tit-for-Tat: Mirror opponent's last move
    last_opp_move = opp_history[-1]
    
    # Final rounds adjustment: Defect in last 2 rounds if opponent has ever defected
    remaining_rounds = 10 - len(my_history)
    if remaining_rounds <= 2:
        if "D" in opp_history:
            return "D"
        else:
            return "C"
    
    return last_opp_move